///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _MAINDLG_CPP
#define _MAINDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.H>

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../../SharedClasses/CMemPool/CMemPool.H"

#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Console.H"
#include "../Source/NewDB.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/Splash.H"
#include "../Dialogs/SysStats.H"
#include "../Dialogs/CreateNewDB.H"
#include "../Dialogs/AskPwd.H"
#include "../Dialogs/SetNewGUIPwd.H"

#include "../CSockSrvr/CSockSrvr.H"
#include "../../SharedClasses/Graph/Graph.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND hMainDialog = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND hStaticFrame = NULL;
    static HWND hConnections = NULL;
    static HWND hTotalConnects = NULL;
    static HWND hWarnings = NULL;
    static HWND hErrors = NULL;
	static HWND hUsageGraph = NULL;

	static HMENU SystemMenu = NULL;

	static int iLastWidth = 0;
	static int iLastHeight = 0;

    //--------------------------------------------------------------------------

    if(uMsg == WM_INITDIALOG)
    {
		if(gdwGUIPWHashSz > 0)
		{
			if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_ASKPWD), hWnd, (DLGPROC)AskPwdDialog) != 100)
			{
				EndDialog(hWnd, 0);
				return TRUE;
			}
		}

        hMainDialog = hWnd;
		gbIsMainDialogOpen = true;

        SystemMenu = GetSystemMenu(hWnd, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        MDI.hMenu = LoadMenu(ghAppInstance, MAKEINTRESOURCE(IDR_SERVERDLGMENU));
		MDI.hLogList = GetDlgItem(hWnd, IDC_LOGLIST);
		MDI.hStatusBar = CreateStatusWindow(WS_CHILD|WS_VISIBLE, "Transactions: 0/s", hWnd, 1);

        int Widths[] = {200, -1};
        SendMessage(MDI.hStatusBar, (UINT)SB_SETPARTS, (WPARAM)2, (LPARAM)&Widths);

		SetMenu(hWnd, MDI.hMenu);

		hUsageGraph    = GetDlgItem(hWnd, IDC_USAGEGRAPH);
		hStaticFrame   = GetDlgItem(hWnd, IDC_STATICFRAME);
        hConnections   = GetDlgItem(hWnd, IDC_CONNECTIONS);
        hTotalConnects = GetDlgItem(hWnd, IDC_TOTALCONNECTS);
        hWarnings      = GetDlgItem(hWnd, IDC_WARNINGS);
        hErrors        = GetDlgItem(hWnd, IDC_ERRORS);

		RECT WindowRECT;
        GetClientRect(hWnd, &WindowRECT);
        MoveWindow(MDI.hLogList, 0, 101, WindowRECT.right, ((WindowRECT.bottom-20) - 101), TRUE);
        MoveWindow(hStaticFrame, 0, 0, WindowRECT.right, 100, TRUE);
        MoveWindow(hUsageGraph, 190, 10, (WindowRECT.right-195), 84, TRUE);

		if(gbShowSplashScreen)
		{
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_SPLASH), hWnd, (DLGPROC)SplashDialog);
		}

        if(gbDebugMode)
			CheckMenuItem(MDI.hMenu, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
		else CheckMenuItem(MDI.hMenu, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);

        if(gServer.cbActive)
		{
			EnableMenuItem(MDI.hMenu, ID_SERVER_STOP, MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(MDI.hMenu, ID_SERVER_START, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
		}
		else{
			EnableMenuItem(MDI.hMenu, ID_SERVER_STOP, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
			EnableMenuItem(MDI.hMenu, ID_SERVER_START, MF_BYCOMMAND|MF_ENABLED);
		}

		Set_Long(hConnections, gServer.GetCurrentClients());
        Set_Long(hTotalConnects, gdwTotalConnects);
        Set_Long(hWarnings, gdwWarningCount);
        Set_Long(hErrors, gdwErrorCount);

		SetTimer(hWnd, 0, 100, NULL);
		SetTimer(hWnd, 1, 1000, NULL);

		if(gMem.IsDebug())
		{
			SetTimer(hWnd, 2, 1000, NULL);
		}

		EnterCriticalSection(&csTransPerSecond);
		giTransProcessed = 0;
		LeaveCriticalSection(&csTransPerSecond);

		InitGraph(hUsageGraph, RGB(0,0,255), RGB(240,240,240), 2, 1);

		CenterWindow(hWnd);

		if(!IsServerConfigured(true))
		{
		}

		return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_COMMAND)
    {
		if(wParam == ID_SPECIAL_SETGUIPWD)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_SETGUIPWD), hWnd, (DLGPROC)SetGUIPwdDialog);
            return TRUE;
        }

		if(wParam == ID_REPLICATION_SETUPNEWDATABASE)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_CREATENEWDB), hWnd, (DLGPROC)CreateNewDBDialog);
            return TRUE;
        }

		if(wParam == ID_SERVER_SYSTEMSTATISTICS)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_SYSSTATS), hWnd, (DLGPROC)SysStatsDialog);
            return TRUE;
        }

		if(wParam == ID_SPECIAL_OPENCONSOLE)
        {
            if(gbConsoleOpen)
                CloseConsole();
            else OpenConsole();
            return TRUE;
        }

        if(wParam == ID_HELP_ABOUT)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = hWnd;

            NetLogo(&ADI);
            return true;
        }

        if(wParam == ID_SPECIAL_DEBUGMODE)
        {
            if(gbDebugMode)
            {
                CheckMenuItem(MDI.hMenu, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);
                gbDebugMode = false;
            }
            else{
                CheckMenuItem(MDI.hMenu, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
                gbDebugMode = true;
            }
            return TRUE;
        }

        if(wParam == ID_SERVER_START)
        {
            StartServer();
			if(gServer.cbActive)
			{
				EnableMenuItem(MDI.hMenu, ID_SERVER_STOP, MF_BYCOMMAND|MF_ENABLED);
				EnableMenuItem(MDI.hMenu, ID_SERVER_START, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
			}
			else{
				EnableMenuItem(MDI.hMenu, ID_SERVER_STOP, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
				EnableMenuItem(MDI.hMenu, ID_SERVER_START, MF_BYCOMMAND|MF_ENABLED);
			}
            return TRUE;
        }

        if(wParam == ID_SERVER_STOP)
        {
            StopServer();
			if(gServer.cbActive)
			{
				EnableMenuItem(MDI.hMenu, ID_SERVER_STOP, MF_BYCOMMAND|MF_ENABLED);
				EnableMenuItem(MDI.hMenu, ID_SERVER_START, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
			}
			else{
				EnableMenuItem(MDI.hMenu, ID_SERVER_STOP, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
				EnableMenuItem(MDI.hMenu, ID_SERVER_START, MF_BYCOMMAND|MF_ENABLED);
			}
            return TRUE;
        }

		if(wParam == ID_SERVER_CLOSE)
        {
            gbIsMainDialogOpen = false;
			KillTimer(hWnd, 0);
			KillTimer(hWnd, 1);
			CloseGraph(hUsageGraph);
            EndDialog(hWnd,0);
            return TRUE;
        }

        if(wParam == ID_SERVER_SETTINGS)
        {
			LaunchConfigDlg(hWnd);
            return TRUE;
        }

        return FALSE;
    }

	//--------------------------------------------------------------------------

	if(uMsg == WM_TIMER)
    {
		if(wParam == 0)
		{
			int iConnects = gServer.GetCurrentClients();

			Set_Long(hConnections, iConnects);
			Set_Long(hTotalConnects, gdwTotalConnects);
			Set_Long(hWarnings, gdwWarningCount);
			Set_Long(hErrors, gdwErrorCount);

			UpdateGraph(hUsageGraph, iConnects + 1, gdwMaxClients + 1);

			DrawGraph(hUsageGraph, RGB(255,255,255));
		}
		else if(wParam == 1)
		{
			char sText[255];

			EnterCriticalSection(&csTransPerSecond);
			sprintf_s(sText, sizeof(sText), "Transactions: %d/s", giTransProcessed);
			giTransProcessed = 0;
			LeaveCriticalSection(&csTransPerSecond);

			SendMessage(MDI.hStatusBar, (UINT)SB_SETTEXT, (WPARAM)0, (LPARAM) sText);
		}
		#ifdef _DEBUG_MEMPOOL
			else if(wParam == 2)
			{
				char sText[255];
				sprintf_s(sText, sizeof(sText),
					"Allocations: %d/%d",
					gMem.GetMemAllocationCount(),
					gMem.GetSlotAllocationCount()
				);
				SendMessage(MDI.hStatusBar, (UINT)SB_SETTEXT, (WPARAM)1, (LPARAM) sText);
			}
		#endif

		return true;
    }

	//--------------------------------------------------------------------------

	if(uMsg == WM_SIZE)
    {
		if(wParam != SIZE_MAXHIDE && wParam != SIZE_MAXSHOW && wParam != SIZE_MINIMIZED)
		{
			int nWidth = LOWORD(lParam);
			int nHeight = HIWORD(lParam);

			if(iLastWidth != nWidth || iLastHeight != nHeight)
			{
				if(nWidth < 300)
					nWidth = iLastWidth;

				if(nHeight < 150)
					nHeight = iLastHeight;

				iLastWidth = nWidth;
				iLastHeight = nHeight;

				CloseGraph(hUsageGraph);

				MoveWindow(MDI.hLogList, 0, 101, nWidth, (nHeight-20) - 101, TRUE);
				MoveWindow(MDI.hStatusBar, nWidth-20, nHeight-20, nWidth, nHeight, TRUE);
				MoveWindow(hStaticFrame, 0, 0, nWidth, 100, TRUE);
				MoveWindow(hUsageGraph, 190, 10, nWidth-195, 84, TRUE);

				InitGraph(hUsageGraph, RGB(0,0,255), RGB(240,240,240), 2, 1);
				//UpdateGraph(hUsageGraph, 10, gdwMaxClients);
			}
		}
		return FALSE;//Return false of we process WM_SIZE.
    }

	//--------------------------------------------------------------------------

	if(uMsg == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(hWnd, &ThisPS);

        // Any painting should be done here

        EndPaint(hWnd, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = hWnd;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_CLOSE)  // Received Close Message
    {
        gbIsMainDialogOpen = false;
	    KillTimer(hWnd, 0);
		KillTimer(hWnd, 1);
		CloseGraph(hUsageGraph);
		EndDialog(hWnd, 0);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
